using System;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Dialog used to handle change of VistA verify code. It asks user for old, 
	/// new, new check verify codes and returns them to caller.
	/// </summary>
	public class DlgVistAChangeVerifyCode : DlgVistABase
	{
		private GroupBox groupBox1;
		
		private VbecsButton btnCancel;
		private VbecsButton btnContinue;

		private TextBox txtOldVerifyCode;
		private TextBox txtNewVerifyCode;
		private TextBox txtNewCheckVerifyCode;
		private Label label1;
		private Label label2;
		private Label label3;
		private Label lblCodeChangeInstructions;
		
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Default parameterless constructor added for VS.NET designer support.
		/// </summary>
		internal DlgVistAChangeVerifyCode()
			: base()
		{
			InitializeComponent();		
			this.btnCancel.Text = "Cancel";
			this.btnContinue.Text = "Continue";
		}

		/// <summary>
		/// Actual constructor that should be used by the application.
		/// </summary>
		/// <param name="serverInfo">Remote VistA server info.</param>
		/// <param name="serverConnectionInfo"></param>
		public DlgVistAChangeVerifyCode( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo )
			: base( serverInfo, serverConnectionInfo )
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC102.DlgVistAChangeVerifyCode());
			//
			this.SetControlBindings( this.btnContinue, this.btnCancel, this.txtOldVerifyCode );

			txtOldVerifyCode.TextChanged += new EventHandler( CodeTextBoxes_TextChanged );
			txtNewVerifyCode.TextChanged += new EventHandler( CodeTextBoxes_TextChanged );
			txtNewCheckVerifyCode.TextChanged += new EventHandler( CodeTextBoxes_TextChanged );

			SetTooltips();

			lblCodeChangeInstructions.Text = StrRes.OtherMsg.UC102.VistAVerifyCodeChangeCodeRequirements().ResString;
			this.btnCancel.Text = "Cancel";
			this.btnContinue.Text = "Continue";
		}

		/// <summary>
		/// Text changed event hanler for all text boxes clearing validation messages from all error providers
		/// when text changes.
		/// </summary>
		/// <param name="sender">Standard sender object.</param>
		/// <param name="e">Standard event arguments.</param>
		private void CodeTextBoxes_TextChanged( object sender, EventArgs e )
		{
			ResetErpValidationMessages();
		}

		/// <summary>
		/// Clears validation messages for all text boxes on the form
		/// </summary>
		protected override void ClearFormControlsValidationErrorMessages()
		{
			ClearControlValidationErrorMessage( txtOldVerifyCode );
			ClearControlValidationErrorMessage( txtNewVerifyCode );
			ClearControlValidationErrorMessage( txtNewCheckVerifyCode );
		}

		/// <summary>
		/// Sets tooltips for all controls on form.
		/// </summary>
		private void SetTooltips()
		{
			SetThisToolTip( btnCancel, StrRes.Tooltips.UC102.VistAChangeVerifyCodebtnCancel() );
			SetThisToolTip( btnContinue, StrRes.Tooltips.UC102.VistAChangeVerifyCodebtnContinue() );
			SetThisToolTip( txtNewVerifyCode, StrRes.Tooltips.UC102.VistAChangeVerifyCodetxtNewVerifyCode() );
			SetThisToolTip( txtNewCheckVerifyCode, StrRes.Tooltips.UC102.VistAChangeVerifyCodetxtNewCheckVerifyCode() );
			SetThisToolTip( txtOldVerifyCode, StrRes.Tooltips.UC102.VistAChangeVerifyCodetxtOldVerifyCode() );
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.lblCodeChangeInstructions = new System.Windows.Forms.Label();
			this.btnCancel = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnContinue = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.label3 = new System.Windows.Forms.Label();
			this.txtNewCheckVerifyCode = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.txtNewVerifyCode = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.txtOldVerifyCode = new System.Windows.Forms.TextBox();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(592, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 213);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.lblCodeChangeInstructions);
			this.groupBox1.Controls.Add(this.btnCancel);
			this.groupBox1.Controls.Add(this.btnContinue);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.txtNewCheckVerifyCode);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.txtNewVerifyCode);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.txtOldVerifyCode);
			this.groupBox1.Location = new System.Drawing.Point(0, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(592, 192);
			this.groupBox1.TabIndex = 2;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "The Verify Code must be changed to log onto VistA";
			// 
			// lblCodeChangeInstructions
			// 
			this.lblCodeChangeInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblCodeChangeInstructions.BackColor = System.Drawing.SystemColors.Info;
			this.lblCodeChangeInstructions.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.lblCodeChangeInstructions.ForeColor = System.Drawing.SystemColors.InfoText;
			this.lblCodeChangeInstructions.Location = new System.Drawing.Point(16, 128);
			this.lblCodeChangeInstructions.Name = "lblCodeChangeInstructions";
			this.lblCodeChangeInstructions.Size = new System.Drawing.Size(560, 48);
			this.lblCodeChangeInstructions.TabIndex = 10;
			this.lblCodeChangeInstructions.Text = "IMPORTANT: The VistA Verify Code must be a mix of 6 to 20 alphanumeric and punctu" +
				"ation characters. It must not contain a semicolon, caret, quotation mark, or col" +
				"on, and cannot be mail-box.";
			this.lblCodeChangeInstructions.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Image = null;
			this.btnCancel.Location = new System.Drawing.Point(480, 80);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(96, 24);
			this.btnCancel.TabIndex = 10;
			// 
			// btnContinue
			// 
			this.btnContinue.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnContinue.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnContinue.Image = null;
			this.btnContinue.Location = new System.Drawing.Point(480, 24);
			this.btnContinue.Name = "btnContinue";
			this.btnContinue.Size = new System.Drawing.Size(96, 24);
			this.btnContinue.TabIndex = 9;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 88);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(152, 24);
			this.label3.TabIndex = 8;
			this.label3.Text = "Confirm New Verify Code*";
			// 
			// txtNewCheckVerifyCode
			// 
			this.txtNewCheckVerifyCode.AccessibleDescription = "Confirm New Verify Code";
			this.txtNewCheckVerifyCode.AccessibleName = "Confirm New Verify Code";
			this.txtNewCheckVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtNewCheckVerifyCode.Location = new System.Drawing.Point(168, 88);
			this.txtNewCheckVerifyCode.MaxLength = 255;
			this.txtNewCheckVerifyCode.Name = "txtNewCheckVerifyCode";
			this.txtNewCheckVerifyCode.PasswordChar = '*';
			this.txtNewCheckVerifyCode.Size = new System.Drawing.Size(280, 20);
			this.txtNewCheckVerifyCode.TabIndex = 7;
			this.txtNewCheckVerifyCode.Text = "";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(152, 24);
			this.label2.TabIndex = 6;
			this.label2.Text = "New Verify Code*";
			// 
			// txtNewVerifyCode
			// 
			this.txtNewVerifyCode.AccessibleDescription = "New Verify Code";
			this.txtNewVerifyCode.AccessibleName = "New Verify Code";
			this.txtNewVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtNewVerifyCode.Location = new System.Drawing.Point(168, 56);
			this.txtNewVerifyCode.MaxLength = 255;
			this.txtNewVerifyCode.Name = "txtNewVerifyCode";
			this.txtNewVerifyCode.PasswordChar = '*';
			this.txtNewVerifyCode.Size = new System.Drawing.Size(280, 20);
			this.txtNewVerifyCode.TabIndex = 5;
			this.txtNewVerifyCode.Text = "";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(152, 24);
			this.label1.TabIndex = 4;
			this.label1.Text = "Current Verify Code*";
			// 
			// txtOldVerifyCode
			// 
			this.txtOldVerifyCode.AccessibleDescription = "Current Verify Code";
			this.txtOldVerifyCode.AccessibleName = "Current Verify Code";
			this.txtOldVerifyCode.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOldVerifyCode.Location = new System.Drawing.Point(168, 24);
			this.txtOldVerifyCode.MaxLength = 255;
			this.txtOldVerifyCode.Name = "txtOldVerifyCode";
			this.txtOldVerifyCode.PasswordChar = '*';
			this.txtOldVerifyCode.Size = new System.Drawing.Size(280, 20);
			this.txtOldVerifyCode.TabIndex = 3;
			this.txtOldVerifyCode.Text = "";
			// 
			// DlgVistAChangeVerifyCode
			// 
			this.AcceptButton = this.btnContinue;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(592, 253);
			this.Controls.Add(this.groupBox1);
			this.hlphelpChm.SetHelpKeyword(this, "Using_UC_18.htm#VISTA_Logon_Screen1");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(600, 280);
			this.Name = "DlgVistAChangeVerifyCode";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VistA Logon - Change Verify Code";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgVistAChangeVerifyCode_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Validates form data (entered VistA security codes are valid) and sets error message for error provider.
		/// </summary>
		/// <returns>True if entered VistA security codes are valid. Otherwise - false.</returns>
		protected override bool IsValidErrorProviderBoundCheck()
		{
			bool	
				_currentCodeIsValid = ValidateSecurityCodeTextBox( txtOldVerifyCode ),
				_newCodesAreValid = ForcedCheckLogicAnd( ValidateSecurityCodeTextBox( txtNewVerifyCode ), ValidateSecurityCodeTextBox( txtNewCheckVerifyCode ) ),
				_newCodesAreEqual = _newCodesAreValid ? ValidateNewCodesEquality() : true;

			return _currentCodeIsValid & _newCodesAreValid & _newCodesAreEqual;
		}

		/// <summary>
		/// Validates that new verify code matches new check verify code and sets error message for error provider.
		/// </summary>
		/// <returns></returns>
		protected virtual bool ValidateNewCodesEquality()
		{
			bool _isValid = txtNewVerifyCode.Text.ToUpper() == txtNewCheckVerifyCode.Text.ToUpper();

			if( _isValid )
				ClearControlValidationErrorMessage( txtNewCheckVerifyCode );
			else
				SetErpValidationErrorMessage( txtNewCheckVerifyCode, StrRes.ValidMsg.UC102.NewVerifyCodesDoNotMatch().ResString );

			return _isValid;
		}

		/// <summary>
		/// User's old VistA verify code.
		/// </summary>
		public VistASecurityCode OldVerifyCode
		{
			get
			{
				// ToUpper() is added to fix M VistALink listener case-sensitivity problems 
				// during verify code change.
				return new VistASecurityCode( txtOldVerifyCode.Text.ToUpper() );
			}
		}

		/// <summary>
		/// User'ss new VistA verify code.
		/// </summary>
		public VistASecurityCode NewVerifyCode
		{
			get
			{
				// ToUpper() is added to fix M VistALink listener case-sensitivity problems
				// during verify code change.
				return new VistASecurityCode( txtNewVerifyCode.Text.ToUpper() );
			}
		}

		/// <summary>
		/// User's new check verify code (the same as new verify code, but entered second time to ensure user has typed in proper code).
		/// </summary>
		public VistASecurityCode NewCheckVerifyCode
		{
			get
			{
				// ToUpper() is added to fix M VistALink listener case-sensitivity problems
				// during verify code change.
				return new VistASecurityCode( txtNewCheckVerifyCode.Text.ToUpper() );
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgVistAChangeVerifyCode_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			//no tooltips to speak... speak only error providers
			this.SpeakMessage( StrRes.OtherMsg.UC102.VistAVerifyCodeChangeCodeRequirements().ResString);
		}

	}
}

